/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* Subject : Pulse Generator
/* Contents:  α׷ ڰ ϴ ļ ޽ ߻
/*       ŵϴ. , α׷ ޽  NBR_PULSES
/*        մϴ.
/* - Remarks :
/*	   1.   COMI-SD501 忡 밡մϴ.
/******************************************************************/
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidas.h"

#define FREQ	1000.f /* Pulse freq. = 1 kHz */
#define NBR_PULSES 1000  /* 0  => Infinite number of pulses */
						 /* others => The number of pulses to generate */
#define PG_CH	0  /* Pulse Generator Channel number */

void main()
{
	HANDLE hDevice;
	double ActFreq;

	COMI_LoadDll();
	hDevice = COMI_LoadDevice (COMI_SD501, 0); /* Load device */

	printf("Generating pulses through CH%d\n", PG_CH);
	printf("Set Freq.(Hz)    = %.0f\n", FREQ);
	if(NBR_PULSES == 0)
		printf("Num pulses = Infinite\n");
	else
		printf("Num pulses = %d\n", NBR_PULSES);
	/* Start pulse generation */
	ActFreq = COMI_PG_Start(hDevice, PG_CH, FREQ, NBR_PULSES);
	printf("Actual Freq.(Hz) = %.0f\n\n", ActFreq);
	while(!kbhit()){
		/* Check if generation is completed */
		if(!COMI_PG_IsActive(hDevice, PG_CH))
			break;
	}
	printf("Pulse generation is completed!\n");
	printf("Press any key to exit!\n");
	getch();

	COMI_PG_Stop (hDevice, PG_CH); /* Stop pulse generation */
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}